/*
 * Decompiled with CFR 0.152.
 */
package ec.gob.sri.dimm.ats.modelo.obj.exportacion;

import ec.gob.sri.dimm.api.modelo.ObjetoModelo;
import ec.gob.sri.dimm.api.modelo.persistencia.Exportable;
import ec.gob.sri.dimm.api.modelo.persistencia.Importable;
import ec.gob.sri.dimm.api.modelo.validacion.ResultadoValidacion;
import ec.gob.sri.dimm.api.modelo.validacion.ValidacionIdentificacion;
import ec.gob.sri.dimm.ats.modelo.obj.FiscalidadInternacional;
import ec.gob.sri.dimm.ats.modelo.obj.Iva;
import ec.gob.sri.dimm.ats.modelo.obj.PagoLocalExterior;
import ec.gob.sri.dimm.ats.modelo.obj.Sujeto;
import ec.gob.sri.dimm.ats.modelo.util.Constantes;
import ec.gob.sri.dimm.ats.modelo.util.Util;
import ec.gob.sri.dimm.data.impl.UtilCatalogosATS;
import java.util.Map;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class ClienteExportacion
extends Sujeto
implements Importable,
Exportable {
    private static final long serialVersionUID = -7165096025356786368L;
    public static final String C_PARTE_RELACIONADA = "descripcionTipoProveedor";
    private boolean parteRelacionada;
    private PagoLocalExterior pagoLocalExterior;

    public ClienteExportacion() {
        this.parteRelacionada = false;
        this.pagoLocalExterior = new PagoLocalExterior(true);
        this.pagoLocalExterior.setPropietario((ObjetoModelo)this);
    }

    public ClienteExportacion(String string, String string2, String txVentas) {
        super(string, string2, txVentas);
    }

    @Override
    protected ResultadoValidacion validarObjeto() {
        ResultadoValidacion resultado = new ResultadoValidacion();
        if ("L".equals(this.getTipoIdentificacion()) ? !ValidacionIdentificacion.validarOtrasIdentificaciones((String)this.getTipoIdentificacion(), (String)this.getIdentificacion(), (ResultadoValidacion)resultado, (Integer)3, (Integer)13, (String)"PLACA o RAMV/CPN").esEstadoExitoso() : !ValidacionIdentificacion.validarTodaIdentificacion((String)this.getTipoIdentificacion(), (String)this.getIdentificacion(), (ResultadoValidacion)resultado, (Integer)3, (Integer)13).esEstadoExitoso()) {
            return resultado;
        }
        if (!this.validacionExtra(resultado).esEstadoExitoso()) {
            return resultado;
        }
        if (resultado.esEstadoExitoso() && !(resultado = this.getPagoLocalExterior().validar()).esEstadoExitoso()) {
            return resultado;
        }
        return resultado.pasarValidacion();
    }

    @Override
    protected ResultadoValidacion validacionExtra(ResultadoValidacion resultado) {
        Iva iva = (Iva)this.getRaizModelo();
        if (iva.periodo.isAnexoEnPeriodoDesdeMayo2016() && "P".equals(this.getTipoIdentificacion())) {
            if (this.getTipoProveedor() == null) {
                resultado.fallarValidacion("Debe seleccionar el tipo de cliente");
                return resultado;
            }
            resultado = this.validarRazonSocial(iva.periodo, "exportador", resultado);
        }
        return resultado;
    }

    @Override
    public ClienteExportacion crearCopiaEdicion() {
        ClienteExportacion copia = new ClienteExportacion();
        copia.setTipoIdentificacion(super.getTipoIdentificacion());
        copia.setIdentificacion(super.getIdentificacion());
        copia.setDescripcionTipoIdentificacion(super.getDescripcionTipoIdentificacion());
        copia.setParteRelacionada(this.parteRelacionada);
        copia.setTipoProveedor(super.getTipoProveedor());
        copia.setDescripcionTipoProveedor(super.getDescripcionTipoProveedor());
        copia.setRazonSocial(super.getRazonSocial());
        copia.setPropietario(this.propietario);
        copia.setPagoLocalExterior(this.pagoLocalExterior.crearCopiaEdicion());
        copia.getPagoLocalExterior().setPropietario((ObjetoModelo)copia);
        copia.getPagoLocalExterior().setExportacion(true);
        return copia;
    }

    @Override
    public void actualizarInformacion(Sujeto copiaEdicion) {
        ClienteExportacion comprador = (ClienteExportacion)copiaEdicion;
        this.setParteRelacionada(comprador.parteRelacionada);
        this.setPagoLocalExterior(((ClienteExportacion)copiaEdicion).getPagoLocalExterior());
        super.actualizarInformacion(copiaEdicion);
    }

    @Override
    public Object importar(Element elemento, Map<String, Element> mapaData) {
        NodeList valorList = elemento.getElementsByTagName("tpIdClienteEx");
        Element eValor = (Element)valorList.item(0);
        this.setTipoIdentificacion(UtilCatalogosATS.crearInstancia().obtenerTipoIdentificacionSecuencia("4", eValor.getTextContent().trim()));
        this.setDescripcionTipoIdentificacion(Constantes.CATALOGOS_SUJETO.get(this.getTipoIdentificacion()));
        valorList = elemento.getElementsByTagName("idClienteEx");
        eValor = (Element)valorList.item(0);
        this.setIdentificacion(eValor.getTextContent().trim());
        if (Util.existeElementoImportar(elemento, "parteRelExp")) {
            valorList = elemento.getElementsByTagName("parteRelExp");
            eValor = (Element)valorList.item(0);
            this.setParteRelacionada(Util.importarBooleano(eValor));
        }
        this.importarTipoClienteYRazonSocial(elemento);
        this.importarPago(elemento);
        return this;
    }

    private void importarPago(Element elemento) {
        this.getPagoLocalExterior().setFiscalidad((FiscalidadInternacional)((Object)this.getPagoLocalExterior().getFiscalidad().importarEnExportacion(elemento, null)));
    }

    private void importarTipoClienteYRazonSocial(Element elemento) {
        Element eValor;
        NodeList valorList;
        if (Util.existeElementoImportar(elemento, "tipoCli")) {
            valorList = elemento.getElementsByTagName("tipoCli");
            eValor = (Element)valorList.item(0);
            this.setTipoProveedor(eValor.getTextContent().trim());
            this.setDescripcionTipoProveedor(UtilCatalogosATS.obtenerNombreDetalleCatalogo((String)"TIPOSIDPROV", (String)this.getTipoProveedor()));
        }
        if (Util.existeElementoImportar(elemento, "denoExpCli")) {
            valorList = elemento.getElementsByTagName("denoExpCli");
            eValor = (Element)valorList.item(0);
            this.setRazonSocial(eValor.getTextContent().trim());
        }
    }

    public Element exportar(Document documento, Element tagDetallExportacion) {
        Element emDetExp = null;
        emDetExp = documento.createElement("tpIdClienteEx");
        emDetExp.setTextContent(UtilCatalogosATS.crearInstancia().obtenerTipoIdentificacion("4", this.getTipoIdentificacion()));
        tagDetallExportacion.appendChild(emDetExp);
        emDetExp = documento.createElement("idClienteEx");
        emDetExp.setTextContent(this.getIdentificacion());
        tagDetallExportacion.appendChild(emDetExp);
        emDetExp = documento.createElement("parteRelExp");
        emDetExp.setTextContent(this.getParteRelacionada());
        tagDetallExportacion.appendChild(emDetExp);
        this.exportarDenominacionYRazonSocialDesdeMayo2016(documento, tagDetallExportacion);
        this.exportarFiscalidadDesdeMayo2016(documento, tagDetallExportacion);
        emDetExp = documento.createElement("paisEfecExp");
        emDetExp.setTextContent(this.getPagoLocalExterior().getFiscalidad().getPaisPago());
        tagDetallExportacion.appendChild(emDetExp);
        if ("P".equals(this.getTipoIdentificacion()) && ((Iva)this.getRaizModelo()).periodo.isAnexoEnPeriodoDesdeMarzo2015HastaAbril2016()) {
            emDetExp = documento.createElement("pagoRegFis");
            emDetExp.setTextContent(this.getPagoLocalExterior().getPagoRegimenFiscal());
            tagDetallExportacion.appendChild(emDetExp);
        }
        return tagDetallExportacion;
    }

    private void exportarDenominacionYRazonSocialDesdeMayo2016(Document documento, Element tagDetallExportacion) {
        Element em = null;
        if (((Iva)this.getRaizModelo()).periodo.isAnexoEnPeriodoDesdeMayo2016()) {
            em = documento.createElement("tipoCli");
            em.setTextContent(this.getTipoProveedor());
            tagDetallExportacion.appendChild(em);
            em = documento.createElement("denoExpCli");
            em.setTextContent(this.getRazonSocial());
            tagDetallExportacion.appendChild(em);
        }
    }

    private void exportarFiscalidadDesdeMayo2016(Document documento, Element tagDetallExportacion) {
        Element em = null;
        if (((Iva)this.getRaizModelo()).periodo.isAnexoEnPeriodoDesdeMayo2016()) {
            em = documento.createElement("tipoRegi");
            em.setTextContent(this.getPagoLocalExterior().getFiscalidad().getTipoRegimenFiscalExterior());
            tagDetallExportacion.appendChild(em);
            em = documento.createElement("paisEfecPagoGen");
            em.setTextContent(this.getPagoLocalExterior().getFiscalidad().getPaisRegimenGeneral());
            tagDetallExportacion.appendChild(em);
            em = documento.createElement("paisEfecPagoParFis");
            em.setTextContent(this.getPagoLocalExterior().getFiscalidad().getPaisParaisoFiscal());
            tagDetallExportacion.appendChild(em);
            em = documento.createElement("denopagoRegFis");
            em.setTextContent(this.getPagoLocalExterior().getFiscalidad().getDenominacionRegimen());
            tagDetallExportacion.appendChild(em);
        }
    }

    public PagoLocalExterior getPagoLocalExterior() {
        return this.pagoLocalExterior;
    }

    public void setPagoLocalExterior(PagoLocalExterior pagoLocalExterior) {
        this.pagoLocalExterior = pagoLocalExterior;
    }

    public boolean isParteRelacionada() {
        return this.parteRelacionada;
    }

    public String getParteRelacionada() {
        return this.parteRelacionada ? "SI" : "NO";
    }

    public void setParteRelacionada(boolean parteRelacionada) {
        boolean oldValue = this.parteRelacionada;
        this.parteRelacionada = parteRelacionada;
        this.firePropertyChange(C_PARTE_RELACIONADA, oldValue, this.parteRelacionada);
    }
}

